<?php
require_once 'vendor/autoload.php';
require_once 'apiClient.php';
require_once 'calendarApiClient.php';

$spreadsheetId = '1DazCLN5Dk01un_6Bs8wnvXMw9ZeRFL1lJi-SO-yGYm8';
$worksheetId = 'Sheet1';
$dataIndexCount = 47;
$sheetOwner = 'it@mkpusa.org';
$editor = 'coronarider01@gmail.com';

$calendarId = 'MjRhY2syZGFlM3N0ZzVuODNhcGNhaHF0ajRAZ3JvdXAuY2FsZW5kYXIuZ29vZ2xlLmNvbQ';
$myTimeZone = "Europe/Kiev"; // IANA timezone name

//
// Get the Sheet API client and construct the service object.
//
$client = getClient();
$service = new Google_Service_Sheets($client);


$sheetId = 0;
$sheetInfo = $service->spreadsheets->get($spreadsheetId);
$allsheet_info = $sheetInfo['sheets'];
$idCats = array_column($allsheet_info, 'properties');

$worksheetExist = false;
foreach($idCats as $idCat) {
	if ($idCat->title == $worksheetId) {
		$sheetId = $idCat->sheetId;
		$worksheetExist = true;
		break;
	}
}

if (!$worksheetExist) {
	die('Worksheet not exist');
}


$data = array();

//
// Find First Editable Column Id
//
$colId = 'B';
$colNum = 1;
$params = [
	'valueInputOption' => 'USER_ENTERED'
];
while(1) {

	$range = $worksheetId . "!" . $colId . "2";
	
	$spreadsheet = $service->spreadsheets->get($spreadsheetId, ['includeGridData' => true, 'ranges' => $range]);
	$bgCol = $spreadsheet['sheets'][0]['data'][0]['rowData'][0]['values'][0]['effectiveFormat']['backgroundColor'];
	if (!$bgCol->red && $bgCol->blue && $bgCol->green) {
		$colId++;
		$colNum++;
	} else {
		break;
	}
}

//
// Get DataIndex Row
//
$range = $worksheetId . "!" . "A" . "2" . ":" . "A" . (1 + $dataIndexCount);
$dataIndexRows = $service->spreadsheets_values->get($spreadsheetId, $range)->values;
//
// Get Data Row
//
$range = $worksheetId . "!" . $colId . "2" . ":" . $colId . (1 + $dataIndexCount);
$dataRows = $service->spreadsheets_values->get($spreadsheetId, $range)->values;

for($i = 0 ; $i < $dataIndexCount; $i++) {
	$data[$dataIndexRows[$i][0]] = $dataRows[$i][0];
}
//
// Format BackGround
//
$requests = [
	new Google_Service_Sheets_Request([
        'repeatCell' => [
            'cell' => [
                'userEnteredFormat' => [
                    'backgroundColor' => [
                        'red' => 0,
                        'green' => 1,
                        'blue' => 1
                    ],
                ]
            ],
            'range' => [
                'sheetId' => $sheetId,
                'startRowIndex' => 1,
                'endRowIndex' => $dataIndexCount + 1,
                'startColumnIndex' => $colNum,
                'endColumnIndex' => $colNum + 1
            ],
            'fields' => 'userEnteredFormat.backgroundColor'
        ]
    ]),
    new Google_Service_Sheets_Request([
        'addProtectedRange' => [
            'protectedRange' => [
                'range' => [
                    'sheetId' => $sheetId,
                    'startRowIndex' => 1,
	                'endRowIndex' => $dataIndexCount + 1,
	                'startColumnIndex' => $colNum,
	                'endColumnIndex' => $colNum + 1
                ],
                "editors" => [
		            "users" => [
		              	$sheetOwner,
		              	$editor
		            ]
	          	]
            ]
        ]
    ])
];
$batchUpdateRequest = new Google_Service_Sheets_BatchUpdateSpreadsheetRequest([
	'requests' => $requests
]);
$service->spreadsheets->batchUpdate($spreadsheetId, $batchUpdateRequest);

print_r($data);



//
// Get the Calendar API client and construct the calendar service object.
//
$calendarClient = getCalendarClient();
$calService = new Google_Service_Calendar($calendarClient);

$eventDescription = 'Country: ' . $data['country'] . "\n\n" . 'State: ' . $data['state'] . "\n\n" . 'Note: ' . 'Some notes...' . "\n";

$event = new Google_Service_Calendar_Event([
  	'summary' => $data['title'],
  	'description' => $eventDescription,
  	'start' => [
  	  	'dateTime' => $data['nb_start_date'] . 'T'. $data['nb_start_time'],
  	  	'timeZone' => $myTimeZone
  	],
  	'end' => [
  	  	'dateTime' => $data['nwta_end_date'] . 'T'. $data['nwta_end_time'],
  	  	'timeZone' => $myTimeZone
  	]
]);

$event = $calService->events->insert($calendarId, $event);
printf("Event created: %s\n", $event->htmlLink);

?>
