<?php

require_once 'vendor/autoload.php';
require_once 'apiClient.php';
require_once 'calendarApiClient.php';

$spreadsheetId = '1DazCLN5Dk01un_6Bs8wnvXMw9ZeRFL1lJi-SO-yGYm8';
$worksheetId = 'Sheet1';
$dataIndexCount = 47;
$sheetOwner = 'it@mkpusa.org';
$editor = 'coronarider01@gmail.com';

//$calendarId = '24ack2dae3stg5n83apcahqtj4@group.calendar.google.com';
$calendarId = 'it@mkpusa.org';
$myTimeZone = "Europe/Kiev"; // IANA timezone name

//
// Get the Sheet API client and construct the service object.
//
$client = getClient();
$service = new Google_Service_Sheets($client);


$sheetId = 0;
$sheetInfo = $service->spreadsheets->get($spreadsheetId);
$allsheet_info = $sheetInfo['sheets'];
$idCats = array_column($allsheet_info, 'properties');

$worksheetExist = false;
foreach($idCats as $idCat) {
    if ($idCat->title == $worksheetId) {
        $sheetId = $idCat->sheetId;
        $worksheetExist = true;
        break;
    }
}

if (!$worksheetExist) {
    die('Worksheet not exist');
}


$data = array();

//
// Find First Editable Column Id
//
$colId = 'B';
$colNum = 1;
$params = [
    'valueInputOption' => 'USER_ENTERED'
];
while(1) {

    $range = $worksheetId . "!" . $colId . "2";

    $spreadsheet = $service->spreadsheets->get($spreadsheetId, ['includeGridData' => true, 'ranges' => $range]);
    $bgCol = $spreadsheet['sheets'][0]['data'][0]['rowData'][0]['values'][0]['effectiveFormat']['backgroundColor'];
    if (!$bgCol->red && $bgCol->blue && $bgCol->green) {
        $colId++;
        $colNum++;
    } else {
        break;
    }
}

//
// Get DataIndex Row
//
$range = $worksheetId . "!" . "A" . "2" . ":" . "A" . (1 + $dataIndexCount);
$dataIndexRows = $service->spreadsheets_values->get($spreadsheetId, $range)->values;
//
// Get Data Row
//
$range = $worksheetId . "!" . $colId . "2" . ":" . $colId . (1 + $dataIndexCount);
$dataRows = $service->spreadsheets_values->get($spreadsheetId, $range)->values;

for($i = 0 ; $i < $dataIndexCount; $i++) {
    $data[$dataIndexRows[$i][0]] = $dataRows[$i][0];
}
//
// Format BackGround
//
$requests = [
    new Google_Service_Sheets_Request([
        'repeatCell' => [
            'cell' => [
                'userEnteredFormat' => [
                    'backgroundColor' => [
                        'red' => 0,
                        'green' => 1,
                        'blue' => 1
                    ],
                ]
            ],
            'range' => [
                'sheetId' => $sheetId,
                'startRowIndex' => 1,
                'endRowIndex' => $dataIndexCount + 1,
                'startColumnIndex' => $colNum,
                'endColumnIndex' => $colNum + 1
            ],
            'fields' => 'userEnteredFormat.backgroundColor'
        ]
    ]),
    new Google_Service_Sheets_Request([
        'addProtectedRange' => [
            'protectedRange' => [
                'range' => [
                    'sheetId' => $sheetId,
                    'startRowIndex' => 1,
                    'endRowIndex' => $dataIndexCount + 1,
                    'startColumnIndex' => $colNum,
                    'endColumnIndex' => $colNum + 1
                ],
                "editors" => [
                    "users" => [
                        $sheetOwner,
                        $editor
                    ]
                ]
            ]
        ]
    ])
];
$batchUpdateRequest = new Google_Service_Sheets_BatchUpdateSpreadsheetRequest([
    'requests' => $requests
]);
$service->spreadsheets->batchUpdate($spreadsheetId, $batchUpdateRequest);

print_r($data);



//
// Get the Calendar API client and construct the calendar service object.
//
$calendarClient = getCalendarClient();
$calService = new Google_Service_Calendar($calendarClient);

//$eventDescription = 'Country: ' . $data['country'] . "\n\n" . 'State: ' . $data['state'] . "\n\n" . 'Note: ' . 'Some notes...' . "\n";
if (!$data['registration_link']) {
    $reg_link = 'https://mkpconnect.org/civicrm/event/register?reset=1&id=' . $civi_part_event;
} else {
    $reg_link = $data['registration_link'];
}

$eventDescription = "Location: " . $data['city'] . ", " . $data['state'] . "\n\nLocal Contact:\n" . $data['staff_coordinator'] . "\n" . $data['staff_coordinator_email'] .
    "\n\nOver 60,000 men have taken this step. Men have created spectacular, life-changing, awe-inspiring results. Men like you take this journey. If you’re willing to challenge yourself, you will emerge more the man you were born to be. The world needs you, and a brotherhood of men is ready to support you.\n 
START TIME: Friday evening between 5:30 and 6:00 pm\n 
END TIME:  Sunday afternoon around 4:00 pm.\n\n

Meals, materials, and accommodations are included. After your initial application and deposit, you will be sent an additional questionnaire required to finalize your registration. You will also receive information about the location of the training and what to bring.\n\n " .
"Register Now:\n" . $reg_link;

$event = new Google_Service_Calendar_Event([
    'summary' => $data['title'],
    'description' => $eventDescription,
    'start' => [
        'dateTime' => $data['nb_start_date'] . 'T'. $data['nb_start_time'],
        'timeZone' => $myTimeZone
    ],
    'end' => [
        'dateTime' => $data['nwta_end_date'] . 'T'. $data['nwta_end_time'],
        'timeZone' => $myTimeZone
    ]
]);

$event = $calService->events->insert($calendarId, $event);
printf("Event created: %s\n", $event->htmlLink);



$servername = "173.231.203.156";
$username = "devmkp";
$password = "6uVwXtu8";
$dbname = "devmkp_connect_drupal";
$tablename = "temp_nwta_build_import";

$conn = new mysqli($servername, $username, $password, $dbname);


$sql = "INSERT INTO devmkp_connect_drupal.temp_nwta_build_import
        (title,center_area,region,owner_nid,email_prefix,mkpi,staff_coordinator,staff_coordinator_email,staff_coordinator_phone,part_registrar,part_registrar_email,part_registrar_phone,admin,admin_email,admin_phone,registration_link,staff_start_date,staff_start_time,nb_start_date,nb_start_time,nwta_end_date,nwta_end_time,staff_reg_start,staff_reg_start_time,staff_reg_end,staff_reg_end_time,part_reg_start,part_reg_start_time,part_reg_end,part_reg_end_time,part_fee,staff_fee,mos_fee,accounting_code,class,readiness,multipay,max_part,gateway,reg_login,waitlist,track_vaccine,location,city,state,zip,country)
         VALUES ('" . $data['title'] . "','" . $data['center_area'] . "','" . $data['region'] . "'," . $data['owner_nid'] . ",'" . $data['email_prefix'] . "','" . $data['mkpi'] . "','" . $data['staff_coordinator'] . "','" . $data['staff_coordinator_email'] . "','" . $data['staff_coordinator_phone'] .
                "','" . $data['part_registrar'] . "','" . $data['part_registrar_email'] . "','" . $data['part_registrar_phone'] . "','" . $data['admin'] . "','" . $data['admin_email'] . "','" . $data['admin_phone'] . "','" . $data['registration_link'] . "','" . $data['staff_start_date'] . "','" . $data['staff_start_time'] .
                "','" . $data['nb_start_date'] . "','" . $data['nb_start_time'] . "','" . $data['nwta_end_date'] . "','" . $data['nwta_end_time'] . "','" . $data['staff_reg_start'] . "','" . $data['staff_reg_start_time'] . "','" . $data['staff_reg_end'] . "','" . $data['staff_reg_end_time'] . "','" . $data['part_reg_start'] . "','" . $data['part_reg_start_time'] . "','" . $data['part_reg_end'] . "','" . $data['part_reg_end_time'] . "'," . $data['part_fee'] . "," . $data['staff_fee'] . "," . $data['mos_fee'] . ",'" . $data['accounting_code'] . "','" . $data['class'] . "','" . $data['readiness'] .
                "','" . $data['multipay'] . "'," . $data['max_part'] . ",'" . $data['gateway'] . "','" . $data['reg_login'] . "','" . $data['waitlist'] . "','" . $data['track_vaccine'] . "','" . $data['location'] . "','" . $data['city'] . "','" . $data['state'] . "','" . $data['zip'] . "','" . $data['country'] . "');";
//print_r($sql);
//$results = $conn->query($sql);

print_r ("NWTA has been built. You can close this tab.");

?>