<?php
require_once 'vendor/autoload.php';
require_once 'apiClient.php';

$servername = "173.231.203.156";
$username = "connect";
$password = "6uVwXtu8";
$dbname = "connect_civicrm";
$tablename = "temp_training_evaluation";

$spreadsheetId = '1Lo-Dj3pudq5j_mZiKahpqn1MxPH6BtG4Y2cHu-gv4uU';
$worksheetId = 'TrainingAnalysis';

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
	die("Connection failed: " . $conn->connect_error);
}

echo "\n-------------------------\n";
echo "DB Connected successfully \n";
echo "-------------------------\n\n";

// Get Table Columns
$table_columns = [];
$sql = "DESCRIBE " . $tablename;
$result = $conn->query($sql);
if ($result->num_rows > 0) {
	while($row = $result->fetch_assoc()) {
		array_push($table_columns, $row["Field"]);
  	}
} else {
	die("Table is empty!");
}

// Get Table Data
$table_data = [];
$sql = "SELECT * FROM " . $tablename;
$result = $conn->query($sql);

if ($result->num_rows > 0) {
  	while($row = $result->fetch_assoc()) {
		$tableRow = [];

		foreach($table_columns as $column) {
			if ($row[$column]) {
				array_push($tableRow, $row[$column]);
			} else {
				array_push($tableRow, "");
			}
		}
		array_push($table_data, $tableRow);
  	}
} else {
  	die("Table is empty");
}

// Close Connection
$conn->close();

echo "-------------------------\n";
echo "Fetched All DB data! \n";
echo "-------------------------\n\n";

// Get the API client and construct the service object.
$client = getClient();
$service = new Google_Service_Sheets($client);

$worksheetExist = true;
// Clear Sheet
try {
	$requestBody = new Google_Service_Sheets_BatchClearValuesRequest([
		'ranges' => [$worksheetId . '!1:10000']
	]);
	$response = $service->spreadsheets_values->batchClear($spreadsheetId, $requestBody);
} catch (Exception  $e) {
	$worksheetExist = false;
}

if ($worksheetExist == false) {
	$requests = [
		// Change the worksheet's title.
		new Google_Service_Sheets_Request([
			'addSheet' => [
				'properties' => [
					'title' => 'TrainingAnalysis'
				],
			]
		])
	];
	$batchUpdateRequest = new Google_Service_Sheets_BatchUpdateSpreadsheetRequest([
		'requests' => $requests
	]);
	$service->spreadsheets->batchUpdate($spreadsheetId, $batchUpdateRequest);
}


$dataCount = count($table_data);
$columnCount = count($table_columns);

$start = 'A'; $end = 'A';
for ($i = 1 ; $i < $columnCount; $i++) { $end++; }

$excelData = [];
for ($i = 1; $i <= $dataCount + 1; $i++) {
	if ($i == 1) { array_push($excelData, $table_columns); }
	else { array_push($excelData, $table_data[$i - 2]); }
}

$range = $worksheetId . '!' . $start . '1:' . $end . ($dataCount + 1);
$body = new Google_Service_Sheets_ValueRange([
	'values' => $excelData
]);
$params = [
	'valueInputOption' => 'USER_ENTERED'
];
$result = $service->spreadsheets_values->update($spreadsheetId, $range, $body, $params);

echo "-------------------------\n";
echo "Google sheet updated! \n\n";
echo $dataCount . " rows inserted!\n";
echo "-------------------------\n\n";


//------------------------------------------------------------

$tablename = "temp_training_evaluation_summary";
$spreadsheetId = '1Lo-Dj3pudq5j_mZiKahpqn1MxPH6BtG4Y2cHu-gv4uU';
$worksheetId = 'TrainingAnalysisSum';

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
	die("Connection failed: " . $conn->connect_error);
}

echo "\n-------------------------\n";
echo "DB Connected successfully \n";
echo "-------------------------\n\n";

// Get Table Columns
$table_columns = [];
$sql = "DESCRIBE " . $tablename;
$result = $conn->query($sql);
if ($result->num_rows > 0) {
	while($row = $result->fetch_assoc()) {
		array_push($table_columns, $row["Field"]);
	}
} else {
	die("Table is empty!");
}

// Get Table Data
$table_data = [];
$sql = "SELECT * FROM " . $tablename;
$result = $conn->query($sql);

if ($result->num_rows > 0) {
	while($row = $result->fetch_assoc()) {
		$tableRow = [];

		foreach($table_columns as $column) {
			if ($row[$column]) {
				array_push($tableRow, $row[$column]);
			} else {
				array_push($tableRow, "");
			}
		}
		array_push($table_data, $tableRow);
	}
} else {
	die("Table is empty");
}

// Close Connection
$conn->close();

echo "-------------------------\n";
echo "Fetched All DB data! \n";
echo "-------------------------\n\n";

// Get the API client and construct the service object.
$client = getClient();
$service = new Google_Service_Sheets($client);

$worksheetExist = true;
// Clear Sheet
try {
	$requestBody = new Google_Service_Sheets_BatchClearValuesRequest([
		'ranges' => [$worksheetId . '!1:10000']
	]);
	$response = $service->spreadsheets_values->batchClear($spreadsheetId, $requestBody);
} catch (Exception  $e) {
	$worksheetExist = false;
}

if ($worksheetExist == false) {
	$requests = [
		// Change the worksheet's title.
		new Google_Service_Sheets_Request([
			'addSheet' => [
				'properties' => [
					'title' => 'TrainingAnalysisSum'
				],
			]
		])
	];
	$batchUpdateRequest = new Google_Service_Sheets_BatchUpdateSpreadsheetRequest([
		'requests' => $requests
	]);
	$service->spreadsheets->batchUpdate($spreadsheetId, $batchUpdateRequest);
}


$dataCount = count($table_data);
$columnCount = count($table_columns);

$start = 'A'; $end = 'A';
for ($i = 1 ; $i < $columnCount; $i++) { $end++; }

$excelData = [];
for ($i = 1; $i <= $dataCount + 1; $i++) {
	if ($i == 1) { array_push($excelData, $table_columns); }
	else { array_push($excelData, $table_data[$i - 2]); }
}

$range = $worksheetId . '!' . $start . '1:' . $end . ($dataCount + 1);
$body = new Google_Service_Sheets_ValueRange([
	'values' => $excelData
]);
$params = [
	'valueInputOption' => 'USER_ENTERED'
];
$result = $service->spreadsheets_values->update($spreadsheetId, $range, $body, $params);

echo "-------------------------\n";
echo "Google sheet updated! \n\n";
echo $dataCount . " rows inserted!\n";
echo "-------------------------\n\n";


?>

